USE Obfuscation

IF OBJECT_ID( 'pGenerateObfuscationStatements' ) IS NOT NULL
    DROP PROCEDURE pGenerateObfuscationStatements;

GO

-- this procedure is a little more complicated than it needs to be because I like to see
-- well formatted statements in the teObfuscationTable. If you don't care about that, you 
-- can remove all the CHAR(13)'s and calls to the REPLACE function.
CREATE PROCEDURE pGenerateObfuscationStatements
AS
    SET NOCOUNT ON;

    -- Get the columns for each table
    UPDATE O
    SET O.ObfStatement = 
        -- begin the update statement
        'UPDATE X ' + CHAR(13) +
        'SET ' + CHAR(13) +
        -- get all the columns we need to update
        SUBSTRING( 
            REPLACE(
                (
                    SELECT 
                        ',' + CHAR(13) + '    X.' + C.ColumnName + ' = ' + T.Alias + '.Value' AS [text()]
                    FROM teObfuscationColumn C
                    JOIN tdColumnType T
                        ON T.ColumnTypeCD = C.ColumnTypeCD
                    WHERE C.TableID = O.TableID
                    FOR XML PATH('')
                ), 
                '&#x0D;' /* this is a newline in xml */,
                CHAR(13)
            ), 3, 10000 
        ) + CHAR(13) + 
        -- create the derived table that includes the sequence number
        'FROM ( ' + CHAR(13) +
        '    SELECT ' + CHAR(13) + 
        -- add the columns we need to select
        SUBSTRING(
            REPLACE(
                (
                    SELECT 
                        CHAR(13) + '        X.' + C.ColumnName + ',' AS [text()]
                    FROM teObfuscationColumn C
                    WHERE C.TableID = O.TableID
                    FOR XML PATH('')
                ),
                '&#x0D;',
                CHAR(13)
            ), 2, 10000
        ) + CHAR(13) +
        -- add the row number so we can join to the sequential tables
        '        Num = ROW_NUMBER() OVER( ORDER BY (SELECT 1) ) ' + CHAR(13) +
        '    FROM ' + O.DatabaseName + '..' + O.TableName + ' X ' + CHAR(13) + 
        ') AS X ' + CHAR(13) + 
        -- add all the joins to the sequential tables
        REPLACE(
            (
                SELECT DISTINCT
                    CASE T.JoinTypeCD
                        WHEN 1 THEN 'JOIN ' + T.ViewOrFixedValue + ' ' + T.Alias + CHAR(13) + 
                            '   ON ' + T.Alias + '.ID = X.Num' + CHAR(13)
                        ELSE 'CROSS JOIN ( SELECT Value = ' + T.ViewOrFixedValue + ' ) AS ' + T.Alias + CHAR(13)
                    END [text()]
                FROM teObfuscationColumn C
                JOIN tdColumnType T
                    ON T.ColumnTypeCD = C.ColumnTypeCD
                WHERE C.TableID = O.TableID
                FOR XML PATH('')
            ),
            '&#x0D;',
            CHAR(13)
        )
    FROM teObfuscationTable O
    WHERE O.AutoGenerate = 1

GO